#include <iostream>
#include <string>
using namespace std;

typedef long long ll;
ll gcd(ll a, ll b)
     {
         return b == 0 ? a : gcd(b, a % b);
     }

struct fraction {
    ll a, b;
    fraction(ll a, ll b) {
        ll sign = 1;
        if (b < 0) {
            a *= -1;
            b *= -1;
        }
        ll g = gcd(a < 0 ? -a : a, b < 0 ? -b : b);
        this->a = a / g;
        this->b = b / g;
    }

    fraction operator +(const fraction other) {
        return fraction(a * other.b + other.a * b, b * other.b);
    }
    fraction operator -(const fraction other) {
        return fraction(a * other.b - other.a * b, b * other.b);
    }

};

int len(string s, int at) {
    if (s[at] == 'n')
        return 5;
    else
        return 4;
}

int cnt(string s, int i) {
    int res = 0;
    while (i < s.size()) {
        if (s[i] == 'n') {
            i += len(s, i);
        } else {
            i += len(s, i);
        }
        res++;
    }
    return res;
}

fraction dir(string s, int at) {

    int n = cnt(s, at) - 1;

    fraction rest(0,1);
    if (at + len(s, at) < s.size()) {
         rest = dir(s, at + len(s, at));
    } else {
        if (s[at] == 'n') {
            rest = fraction(0, 1);
        } else {
            rest = fraction(90, 1);
        }

        return rest;
    }

    if (s[at] == 'n') {
        fraction f = fraction(90, 1LL << n);
        fraction x = rest - f;
        return x;
    } else {
        fraction f = fraction(90, 1LL << n);
        fraction x = rest + f;
        return x;
    }
}

int main() {
    string s;
    while (getline(cin, s) && s != "#") {
            fraction res = dir(s, 0);
            cout << res.a;
            if (res.b != 1)
            cout << "/" << res.b;
            cout << endl;
    }

    return 0;
}
